import json
from functools import partial
from policies.base_policy import BasePolicy

# Policy Constructors
def construct_noop_policy():
    from policies.noop_policy import NoopPolicy
    return NoopPolicy

def construct_comm_gpt_policy():
    from policies.comm_gpt_policy import CommGPTPolicy
    return CommGPTPolicy

def construct_comm_llama_policy():
    from policies.comm_llama_policy import CommLlamaPolicy
    return CommLlamaPolicy

def construct_heuristic_comm_policy():
    from policies.heuristic_comm_policy import HeuristicCommPolicy
    return HeuristicCommPolicy

def construct_heuristic_control_policy():
    from policies.heuristic_control_policy import HeuristicControlPolicy
    return HeuristicControlPolicy

def construct_dilu_policy():
    from policies.dilu_policy import DiLUPolicy
    return DiLUPolicy

# Register Policies
POLICY_REGISTRY = {
        'NoopPolicy': construct_noop_policy,
        'DiLUPolicy': construct_dilu_policy,
        'CommGPTPolicy': construct_comm_gpt_policy,
        'CommLlamaPolicy': construct_comm_llama_policy,
        'HeuristicCommPolicy': construct_heuristic_comm_policy,
        'HeuristicControlPolicy': construct_heuristic_control_policy,
        }

# Construct Policy Instances
def construct_policy(
        policy_name: str = 'NoopPolicy',
        **kwargs):
    policy_class = POLICY_REGISTRY[policy_name]()
    return policy_class(**kwargs)

# Construct Policy Maps
def construct_policy_map(
        config,
        ):
    policies = {}
    for config in config.policy_map:
        policy = construct_policy(
                policy_name = config.policy_class,
                **config.kwargs
                )
        policies[config.kwargs.agent_id] = policy

    return policies

if __name__ == '__main__':
    kwargs = {'agent_id':'truck'}
    policy = construct_policy(input('Policy Name:'), **kwargs)
    print(policy.act())
